// Generated by CoffeeScript 1.3.3
(function() {
  var $, bgSettings, canBeEmptyFields, editableFields, enableSaveButton, onDataLoaded, onOptionKeyup, openAdvancedOptions, populateOptions, postSaveHooks, restoreToDefaults, saveOptions, setFieldValue;

  $ = function(id) {
    return document.getElementById(id);
  };

  bgSettings = chrome.extension.getBackgroundPage().Settings;

  editableFields = ["scrollStepSize", "excludedUrls", "linkHintCharacters", "userDefinedLinkHintCss", "keyMappings", "filterLinkHints", "previousPatterns", "nextPatterns", "hideHud", "regexFindMode", "searchUrl"];

  canBeEmptyFields = ["excludedUrls", "keyMappings", "userDefinedLinkHintCss"];

  postSaveHooks = {
    keyMappings: function(value) {
      var commands;
      commands = chrome.extension.getBackgroundPage().Commands;
      commands.clearKeyMappingsAndSetDefaults();
      commands.parseCustomKeyMappings(value);
      return chrome.extension.getBackgroundPage().refreshCompletionKeysAfterMappingSave();
    }
  };

  document.addEventListener("DOMContentLoaded", function() {
    var field, _i, _len;
    populateOptions();
    for (_i = 0, _len = editableFields.length; _i < _len; _i++) {
      field = editableFields[_i];
      $(field).addEventListener("keyup", onOptionKeyup, false);
      $(field).addEventListener("change", enableSaveButton, false);
      $(field).addEventListener("change", onDataLoaded, false);
    }
    $("advancedOptions").addEventListener("click", openAdvancedOptions, false);
    $("showCommands").addEventListener("click", (function() {
      return showHelpDialog(chrome.extension.getBackgroundPage().helpDialogHtml(true, true, "命令列表"), frameId);
    }), false);
    document.getElementById("restoreSettings").addEventListener("click", restoreToDefaults);
    return document.getElementById("saveOptions").addEventListener("click", saveOptions);
  });

  window.onbeforeunload = function() {
    if (!$("saveOptions").disabled) {
      return "您有未保存的选项。";
    }
  };

  onOptionKeyup = function(event) {
    if (event.target.getAttribute("type") !== "checkbox" && event.target.getAttribute("savedValue") !== event.target.value) {
      return enableSaveButton();
    }
  };

  onDataLoaded = function() {
    return $("linkHintCharacters").readOnly = $("filterLinkHints").checked;
  };

  enableSaveButton = function() {
    return $("saveOptions").removeAttribute("disabled");
  };

  saveOptions = function() {
    var field, fieldName, fieldValue, _i, _len;
    for (_i = 0, _len = editableFields.length; _i < _len; _i++) {
      fieldName = editableFields[_i];
      field = $(fieldName);
      if (field.getAttribute("type") === "checkbox") {
        fieldValue = field.checked;
      } else {
        fieldValue = field.value.trim();
        field.value = fieldValue;
      }
      if (!fieldValue && canBeEmptyFields.indexOf(fieldName) === -1) {
        bgSettings.clear(fieldName);
        fieldValue = bgSettings.get(fieldName);
      } else {
        bgSettings.set(fieldName, fieldValue);
      }
      $(fieldName).value = fieldValue;
      $(fieldName).setAttribute("savedValue", fieldValue);
      if (postSaveHooks[fieldName]) {
        postSaveHooks[fieldName](fieldValue);
      }
    }
    return $("saveOptions").disabled = true;
  };

  populateOptions = function() {
    var field, val, _i, _len;
    for (_i = 0, _len = editableFields.length; _i < _len; _i++) {
      field = editableFields[_i];
      val = bgSettings.get(field) || "";
      setFieldValue($(field), val);
    }
    return onDataLoaded();
  };

  restoreToDefaults = function() {
    var field, val, _i, _len;
    for (_i = 0, _len = editableFields.length; _i < _len; _i++) {
      field = editableFields[_i];
      val = bgSettings.defaults[field] || "";
      setFieldValue($(field), val);
    }
    onDataLoaded();
    return enableSaveButton();
  };

  setFieldValue = function(field, value) {
    if (field.getAttribute("type") !== "checkbox") {
      field.value = value;
      return field.setAttribute("savedValue", value);
    } else {
      return field.checked = value;
    }
  };

  openAdvancedOptions = function(event) {
    var element, elements, showOrHideLink, _i, _len;
    elements = document.getElementsByClassName("advancedOption");
    for (_i = 0, _len = elements.length; _i < _len; _i++) {
      element = elements[_i];
      element.style.display = (element.style.display === "table-row" ? "none" : "table-row");
    }
    showOrHideLink = $("advancedOptions");
    if (showOrHideLink.innerHTML.match(/^Show/) != null) {
      showOrHideLink.innerHTML = "隐藏高级选项&hellip;";
    } else {
      showOrHideLink.innerHTML = "显示高级选项&hellip;";
    }
    return event.preventDefault();
  };

}).call(this);
